#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import MySQLdb
import os
path = str(os.path.dirname(os.path.abspath(__file__))) + "/"
dbpath = path + "ch.db"
class DB_MySQL:
    dbname=""
    dbhost=""
    dbusr=""
    dbpasswd=""
    dbport=0
    def __init__(self,dbname,user,passwd,host="localhost",port=3306):
        self.dbname = dbname
        self.dbhost=host
        self.dbusr=user
        self.dbpasswd=passwd
        self.dbport=port
    def connect_db(self):
        """
        dbへの接続
        """
        con=MySQLdb.connect(db=self.dbname,host=self.dbhost,port=self.dbport,user=self.dbusr,passwd=self.dbpasswd,charset="utf8")
        cur=con.cursor()
        cur.execute('set names utf8;')
        return [con,cur]
    def close_db(self,db):
        db[1].close()
        db[0].close()
    def select_by_ontv_ch(self,ontv):
        db=self.connect_db()
        ret=db[1].execute("SELECT bctype,channel,display FROM ch WHERE channel= %s ",(ontv,))
        ret=db[1].fetchall()
        self.close_db(db)
        return ret
    def select_all_rectime(self):
        db=self.connect_db()
        recdata=[]
        dl=db[1].execute("SELECT id,type,chtxt,title,btime,etime,deltatime,deltaday,opt FROM rectime")
        dls=db[1].fetchall()
        for id,typet, chtxt, title, btime, etime, deltatime, deltaday, opt in dls:
            ret={}
            ret['id']=id
            ret['type']=typet
            ret['chtxt']=chtxt
            ret['title']=title.encode('utf-8')
            btime=btime.strftime("%Y-%m-%d %H:%M:%S")
            etime=etime.strftime("%Y-%m-%d %H:%M:%S")
            ret['btime']=btime
            ret['etime']=etime
            ret['opt']=opt
            ret['deltatime']=""
            ret['deltaday']=""
            if deltatime == None:
                deltatime="3"
            if deltaday == None:
                deltaday="7"
            if typet == 'key':
                ret['deltatime']=deltatime
            elif typet == 'keyevery':
                ret['deltatime']=deltatime
                ret['deltaday']=deltaday
            recdata.append(ret)
        self.close_db(db)
        return recdata
    def select_by_chtxt_rectime(self,chtxt):
        db=self.connect_db()
        recdata=[]
        dl=db[1].execute("SELECT type, chtxt, title, btime, etime, deltatime ,deltaday ,opt FROM rectime WHERE chtxt = %s ",(chtxt,))
        d=db[1].fetchall()
        for typet, chtxt, title, btime, etime, deltatime, deltaday, opt in d:
            ret={}
            ret['type']=typet
            ret['chtxt']=chtxt
            ret['title']=title.encode('utf-8')
            btime=btime.strftime("%Y-%m-%d %H:%M:%S")
            etime=etime.strftime("%Y-%m-%d %H:%M:%S")
            ret['btime']=btime
            ret['etime']=etime
            ret['opt']=opt
            if deltatime == None:
                deltatime="3"
            if deltaday == None:
                deltaday="7"
            if typet == 'key':
                ret['deltatime']=deltatime
            elif typet == 'keyevery':
                ret['deltatime']=deltatime
                ret['deltaday']=deltaday
            recdata.append(ret)
        self.close_db(db)
        return recdata
    def select_by_id_rectime(self,id):
        db=self.connect_db()
        recdata=[]
        dl=db[1].execute("SELECT type, chtxt, title, btime, etime, deltatime ,deltaday ,opt FROM rectime WHERE id = %s ",(id,))
        d=db[1].fetchall()
        for typet, chtxt, title, btime, etime, deltatime, deltaday, opt in d:
            ret={}
            ret['type']=typet
            ret['chtxt']=chtxt
            ret['title']=title.encode('utf-8')
            btime=btime.strftime("%Y-%m-%d %H:%M:%S")
            etime=etime.strftime("%Y-%m-%d %H:%M:%S")
            ret['btime']=btime
            ret['etime']=etime
            ret['opt']=opt
            if deltatime == None:
                deltatime="3"
            if deltaday == None:
                deltaday="7"
            if typet == 'key':
                ret['deltatime']=deltatime
            elif typet == 'keyevery':
                ret['deltatime']=deltatime
                ret['deltaday']=deltaday
            recdata.append(ret)
        self.close_db(db)
        return recdata
    def select_all_chdata(self):
        db=self.connect_db()
        ret=db[1].execute("SELECT bctype,ontv,chtxt,ch,csch,updatetime FROM chdata")
        ret=db[1].fetchall()
        self.close_db(db)
        return ret
    def select_by_chtxt_chdata(self,chtxt):
        db=self.connect_db()
        ret=db[1].execute("SELECT bctype,ontv,chtxt,ch,csch,updatetime FROM chdata WHERE chtxt=%s",(chtxt,))
        ret=db[1].fetchall()
        self.close_db(db)
        return ret
    def select_by_station_chdata(self,station):
        db=self.connect_db()
        ret=db[1].execute("SELECT bctype,ontv,chtxt,ch,csch,updatetime FROM chdata WHERE station=%s",(station,))
        ret=db[1].fetchall()
        self.close_db(db)
        return ret
    def select_by_station_name_chdata(self,station_name):
        db=self.connect_db()
        db[1].execute("SELECT bctype,ontv,chtxt,ch,csch,updatetime FROM chdata WHERE station_name=%s",(station_name,))
        ret=db[1].fetchall()
        self.close_db(db)
        return ret
    def add_rectime(self,type="", chtxt="", title="", btime="", etime="", deltatime="", deltaday="", opt=""):
        db = self.connect_db()
        db[1].execute('INSERT IGNORE INTO rectime (type,chtxt,title,btime,etime,deltatime,deltaday,opt) values (%s,%s,%s,%s,%s,%s,%s,%s)', (type, chtxt, title, btime, etime, deltatime, deltaday, opt))
        #db.commit()
        self.close_db(db)
    def count_schedule_rectime(self,btime,etime):
        """
        count rectasknum
        return [te num,bs/cs num]
        """
        db=self.connect_db()
        dbexe="SELECT type,chdata.bctype,rectime.chtxt,rectime.title FROM rectime INNER JOIN chdata ON rectime.chtxt=chdata.chtxt"
        dbexe=dbexe+" WHERE NOT( ( rectime.etime <= %s ) OR ( rectime.btime >= %s ) )"
        Srec=0
        Trec=0
        db[1].execute(dbexe,(btime,etime))
        for typet,bctypet, chtxtt, titlet in db[1].fetchall():
            if (typet=="rec") or (typet=="res") or (typet=="key") or (typet=="keyevery"):
                if bctypet.find("cs")>-1:
                    Srec=Srec+1
                elif bctypet.find("bs")>-1:
                    Srec=Srec+1
                elif bctypet.find("te")>-1:
                    Trec=Trec+1
        self.close_db(db)
        return [Trec,Srec]
    def del_by_id_rectime(self,id):
        db=self.connect_db()
        db[1].execute('DELETE FROM rectime WHERE id='+id)
        self.close_db(db)